/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetParametersByPathRequestModelMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").isBinary(false).build();
    private static final MarshallingInfo<Boolean> RECURSIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Recursive").isBinary(false).build();
    private static final MarshallingInfo<List> PARAMETERFILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterFilters").isBinary(false).build();
    private static final MarshallingInfo<Boolean> WITHDECRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WithDecryption").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final GetParametersByPathRequestModelMarshaller INSTANCE = new GetParametersByPathRequestModelMarshaller();

    private GetParametersByPathRequestModelMarshaller() {
    }

    public static GetParametersByPathRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetParametersByPathRequest getParametersByPathRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getParametersByPathRequest), (String)"getParametersByPathRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getParametersByPathRequest.path(), PATH_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.recursive(), RECURSIVE_BINDING);
            protocolMarshaller.marshall(getParametersByPathRequest.parameterFilters(), PARAMETERFILTERS_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.withDecryption(), WITHDECRYPTION_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)getParametersByPathRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

