/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTargetListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowTargetsResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
    private final List<MaintenanceWindowTarget> targets;
    private final String nextToken;

    private DescribeMaintenanceWindowTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowTarget> targets() {
        return this.targets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTargetsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTargetsResponse other = (DescribeMaintenanceWindowTargetsResponse)((Object)obj);
        return Objects.equals(this.targets(), other.targets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowTargetsResponse").add("Targets", this.targets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowTarget> targets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTargetsResponse model) {
            this.targets(model.targets);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTarget.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(MaintenanceWindowTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<MaintenanceWindowTarget> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(MaintenanceWindowTarget ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<MaintenanceWindowTarget.BuilderImpl> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copyFromBuilder(targets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowTargetsResponse build() {
            return new DescribeMaintenanceWindowTargetsResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
        public Builder targets(Collection<MaintenanceWindowTarget> var1);

        public Builder targets(MaintenanceWindowTarget ... var1);

        public Builder nextToken(String var1);
    }
}

