/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchema;
import software.amazon.awssdk.services.ssm.transform.InventoryItemAttributeUnmarshaller;

public class InventoryItemSchemaUnmarshaller
implements Unmarshaller<InventoryItemSchema, JsonUnmarshallerContext> {
    private static final InventoryItemSchemaUnmarshaller INSTANCE = new InventoryItemSchemaUnmarshaller();

    public InventoryItemSchema unmarshall(JsonUnmarshallerContext context) throws Exception {
        InventoryItemSchema.Builder inventoryItemSchemaBuilder = InventoryItemSchema.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TypeName", targetDepth)) {
                    context.nextToken();
                    inventoryItemSchemaBuilder.typeName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    inventoryItemSchemaBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    inventoryItemSchemaBuilder.attributes(new ListUnmarshaller((Unmarshaller)InventoryItemAttributeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    inventoryItemSchemaBuilder.displayName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InventoryItemSchema)inventoryItemSchemaBuilder.build();
    }

    public static InventoryItemSchemaUnmarshaller getInstance() {
        return INSTANCE;
    }
}

