/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.AccountIdListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionType;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDocumentPermissionRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, ModifyDocumentPermissionRequest> {
    private final String name;
    private final String permissionType;
    private final List<String> accountIdsToAdd;
    private final List<String> accountIdsToRemove;

    private ModifyDocumentPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.permissionType = builder.permissionType;
        this.accountIdsToAdd = builder.accountIdsToAdd;
        this.accountIdsToRemove = builder.accountIdsToRemove;
    }

    public String name() {
        return this.name;
    }

    public DocumentPermissionType permissionType() {
        return DocumentPermissionType.fromValue(this.permissionType);
    }

    public String permissionTypeString() {
        return this.permissionType;
    }

    public List<String> accountIdsToAdd() {
        return this.accountIdsToAdd;
    }

    public List<String> accountIdsToRemove() {
        return this.accountIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIdsToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIdsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDocumentPermissionRequest)) {
            return false;
        }
        ModifyDocumentPermissionRequest other = (ModifyDocumentPermissionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.permissionTypeString(), other.permissionTypeString()) && Objects.equals(this.accountIdsToAdd(), other.accountIdsToAdd()) && Objects.equals(this.accountIdsToRemove(), other.accountIdsToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.permissionTypeString() != null) {
            sb.append("PermissionType: ").append(this.permissionTypeString()).append(",");
        }
        if (this.accountIdsToAdd() != null) {
            sb.append("AccountIdsToAdd: ").append(this.accountIdsToAdd()).append(",");
        }
        if (this.accountIdsToRemove() != null) {
            sb.append("AccountIdsToRemove: ").append(this.accountIdsToRemove()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "PermissionType": {
                return Optional.of(clazz.cast(this.permissionTypeString()));
            }
            case "AccountIdsToAdd": {
                return Optional.of(clazz.cast(this.accountIdsToAdd()));
            }
            case "AccountIdsToRemove": {
                return Optional.of(clazz.cast(this.accountIdsToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String name;
        private String permissionType;
        private List<String> accountIdsToAdd;
        private List<String> accountIdsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDocumentPermissionRequest model) {
            this.name(model.name);
            this.permissionType(model.permissionType);
            this.accountIdsToAdd(model.accountIdsToAdd);
            this.accountIdsToRemove(model.accountIdsToRemove);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType.toString());
            return this;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        public final Collection<String> getAccountIdsToAdd() {
            return this.accountIdsToAdd;
        }

        @Override
        public final Builder accountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdsToAdd(String ... accountIdsToAdd) {
            this.accountIdsToAdd(Arrays.asList(accountIdsToAdd));
            return this;
        }

        public final void setAccountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
        }

        public final Collection<String> getAccountIdsToRemove() {
            return this.accountIdsToRemove;
        }

        @Override
        public final Builder accountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdsToRemove(String ... accountIdsToRemove) {
            this.accountIdsToRemove(Arrays.asList(accountIdsToRemove));
            return this;
        }

        public final void setAccountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyDocumentPermissionRequest build() {
            return new ModifyDocumentPermissionRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, ModifyDocumentPermissionRequest> {
        public Builder name(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(DocumentPermissionType var1);

        public Builder accountIdsToAdd(Collection<String> var1);

        public Builder accountIdsToAdd(String ... var1);

        public Builder accountIdsToRemove(Collection<String> var1);

        public Builder accountIdsToRemove(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

