/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTargetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowTarget
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowTarget> {
    private final String windowId;
    private final String windowTargetId;
    private final String resourceType;
    private final List<Target> targets;
    private final String ownerInformation;
    private final String name;
    private final String description;

    private MaintenanceWindowTarget(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.resourceType = builder.resourceType;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
    }

    public String windowId() {
        return this.windowId;
    }

    public String windowTargetId() {
        return this.windowTargetId;
    }

    public MaintenanceWindowResourceType resourceType() {
        return MaintenanceWindowResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTarget)) {
            return false;
        }
        MaintenanceWindowTarget other = (MaintenanceWindowTarget)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTargetId(), other.windowTargetId()) && Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowId() != null) {
            sb.append("WindowId: ").append(this.windowId()).append(",");
        }
        if (this.windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(this.windowTargetId()).append(",");
        }
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(this.ownerInformation()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.of(clazz.cast(this.windowId()));
            }
            case "WindowTargetId": {
                return Optional.of(clazz.cast(this.windowTargetId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "OwnerInformation": {
                return Optional.of(clazz.cast(this.ownerInformation()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTargetId;
        private String resourceType;
        private List<Target> targets;
        private String ownerInformation;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTarget model) {
            this.windowId(model.windowId);
            this.windowTargetId(model.windowTargetId);
            this.resourceType(model.resourceType);
            this.targets(model.targets);
            this.ownerInformation(model.ownerInformation);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public MaintenanceWindowTarget build() {
            return new MaintenanceWindowTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowTarget> {
        public Builder windowId(String var1);

        public Builder windowTargetId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(MaintenanceWindowResourceType var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder ownerInformation(String var1);

        public Builder name(String var1);

        public Builder description(String var1);
    }
}

