/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowExecutionResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetMaintenanceWindowExecutionResponse> {
    private final String windowExecutionId;
    private final List<String> taskIds;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;

    private GetMaintenanceWindowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskIds = builder.taskIds;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public List<String> taskIds() {
        return this.taskIds;
    }

    public MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionResponse other = (GetMaintenanceWindowExecutionResponse)((Object)obj);
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskIds(), other.taskIds()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(this.windowExecutionId()).append(",");
        }
        if (this.taskIds() != null) {
            sb.append("TaskIds: ").append(this.taskIds()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.of(clazz.cast(this.windowExecutionId()));
            }
            case "TaskIds": {
                return Optional.of(clazz.cast(this.taskIds()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private List<String> taskIds;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionResponse model) {
            this.windowExecutionId(model.windowExecutionId);
            this.taskIds(model.taskIds);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final Collection<String> getTaskIds() {
            return this.taskIds;
        }

        @Override
        public final Builder taskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIds(String ... taskIds) {
            this.taskIds(Arrays.asList(taskIds));
            return this;
        }

        public final void setTaskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public GetMaintenanceWindowExecutionResponse build() {
            return new GetMaintenanceWindowExecutionResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetMaintenanceWindowExecutionResponse> {
        public Builder windowExecutionId(String var1);

        public Builder taskIds(Collection<String> var1);

        public Builder taskIds(String ... var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

