/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.ActivationListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeActivationsResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeActivationsResponse> {
    private final List<Activation> activationList;
    private final String nextToken;

    private DescribeActivationsResponse(BuilderImpl builder) {
        super(builder);
        this.activationList = builder.activationList;
        this.nextToken = builder.nextToken;
    }

    public List<Activation> activationList() {
        return this.activationList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activationList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsResponse)) {
            return false;
        }
        DescribeActivationsResponse other = (DescribeActivationsResponse)((Object)obj);
        return Objects.equals(this.activationList(), other.activationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.activationList() != null) {
            sb.append("ActivationList: ").append(this.activationList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationList": {
                return Optional.of(clazz.cast(this.activationList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<Activation> activationList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsResponse model) {
            this.activationList(model.activationList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Activation.Builder> getActivationList() {
            return this.activationList != null ? (Collection)this.activationList.stream().map(Activation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activationList(Collection<Activation> activationList) {
            this.activationList = ActivationListCopier.copy(activationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationList(Activation ... activationList) {
            this.activationList(Arrays.asList(activationList));
            return this;
        }

        public final void setActivationList(Collection<Activation.BuilderImpl> activationList) {
            this.activationList = ActivationListCopier.copyFromBuilder(activationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeActivationsResponse build() {
            return new DescribeActivationsResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeActivationsResponse> {
        public Builder activationList(Collection<Activation> var1);

        public Builder activationList(Activation ... var1);

        public Builder nextToken(String var1);
    }
}

