/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDocumentRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, CreateDocumentRequest> {
    private final String content;
    private final String name;
    private final String documentType;

    private CreateDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.name = builder.name;
        this.documentType = builder.documentType;
    }

    public String content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public String documentTypeString() {
        return this.documentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentRequest)) {
            return false;
        }
        CreateDocumentRequest other = (CreateDocumentRequest)((Object)obj);
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.documentTypeString(), other.documentTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.documentTypeString() != null) {
            sb.append("DocumentType: ").append(this.documentTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DocumentType": {
                return Optional.of(clazz.cast(this.documentTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String content;
        private String name;
        private String documentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentRequest model) {
            this.content(model.content);
            this.name(model.name);
            this.documentType(model.documentType);
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentRequest build() {
            return new CreateDocumentRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, CreateDocumentRequest> {
        public Builder content(String var1);

        public Builder name(String var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

