/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchRule;

@SdkInternalApi
public class PatchRuleMarshaller {
    private static final MarshallingInfo<StructuredPojo> PATCHFILTERGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchFilterGroup").build();
    private static final MarshallingInfo<String> COMPLIANCELEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceLevel").build();
    private static final MarshallingInfo<Integer> APPROVEAFTERDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApproveAfterDays").build();
    private static final PatchRuleMarshaller INSTANCE = new PatchRuleMarshaller();

    public static PatchRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchRule patchRule, ProtocolMarshaller protocolMarshaller) {
        if (patchRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)patchRule.patchFilterGroup(), PATCHFILTERGROUP_BINDING);
            protocolMarshaller.marshall((Object)patchRule.complianceLevelString(), COMPLIANCELEVEL_BINDING);
            protocolMarshaller.marshall((Object)patchRule.approveAfterDays(), APPROVEAFTERDAYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

