/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutParameterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutParameterRequest> {
    private final String name;
    private final String description;
    private final String value;
    private final String type;
    private final String keyId;
    private final Boolean overwrite;
    private final String allowedPattern;

    private PutParameterRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.value = builder.value;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.overwrite = builder.overwrite;
        this.allowedPattern = builder.allowedPattern;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String value() {
        return this.value;
    }

    public ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String keyId() {
        return this.keyId;
    }

    public Boolean overwrite() {
        return this.overwrite;
    }

    public String allowedPattern() {
        return this.allowedPattern;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutParameterRequest)) {
            return false;
        }
        PutParameterRequest other = (PutParameterRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.overwrite(), other.overwrite()) && Objects.equals(this.allowedPattern(), other.allowedPattern());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.overwrite() != null) {
            sb.append("Overwrite: ").append(this.overwrite()).append(",");
        }
        if (this.allowedPattern() != null) {
            sb.append("AllowedPattern: ").append(this.allowedPattern()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "Overwrite": {
                return Optional.of(clazz.cast(this.overwrite()));
            }
            case "AllowedPattern": {
                return Optional.of(clazz.cast(this.allowedPattern()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String value;
        private String type;
        private String keyId;
        private Boolean overwrite;
        private String allowedPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(PutParameterRequest model) {
            this.name(model.name);
            this.description(model.description);
            this.value(model.value);
            this.type(model.type);
            this.keyId(model.keyId);
            this.overwrite(model.overwrite);
            this.allowedPattern(model.allowedPattern);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Boolean getOverwrite() {
            return this.overwrite;
        }

        @Override
        public final Builder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public final void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        public PutParameterRequest build() {
            return new PutParameterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutParameterRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder keyId(String var1);

        public Builder overwrite(Boolean var1);

        public Builder allowedPattern(String var1);
    }
}

