/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchComplianceDataState;
import software.amazon.awssdk.services.ssm.transform.PatchComplianceDataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchComplianceData
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchComplianceData> {
    private final String title;
    private final String kbId;
    private final String classification;
    private final String severity;
    private final String state;
    private final Instant installedTime;

    private PatchComplianceData(BuilderImpl builder) {
        this.title = builder.title;
        this.kbId = builder.kbId;
        this.classification = builder.classification;
        this.severity = builder.severity;
        this.state = builder.state;
        this.installedTime = builder.installedTime;
    }

    public String title() {
        return this.title;
    }

    public String kbId() {
        return this.kbId;
    }

    public String classification() {
        return this.classification;
    }

    public String severity() {
        return this.severity;
    }

    public PatchComplianceDataState state() {
        return PatchComplianceDataState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Instant installedTime() {
        return this.installedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.kbId());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchComplianceData)) {
            return false;
        }
        PatchComplianceData other = (PatchComplianceData)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.kbId(), other.kbId()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.installedTime(), other.installedTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (this.kbId() != null) {
            sb.append("KBId: ").append(this.kbId()).append(",");
        }
        if (this.classification() != null) {
            sb.append("Classification: ").append(this.classification()).append(",");
        }
        if (this.severity() != null) {
            sb.append("Severity: ").append(this.severity()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.installedTime() != null) {
            sb.append("InstalledTime: ").append(this.installedTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.of(clazz.cast(this.title()));
            }
            case "KBId": {
                return Optional.of(clazz.cast(this.kbId()));
            }
            case "Classification": {
                return Optional.of(clazz.cast(this.classification()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severity()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "InstalledTime": {
                return Optional.of(clazz.cast(this.installedTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchComplianceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String kbId;
        private String classification;
        private String severity;
        private String state;
        private Instant installedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchComplianceData model) {
            this.title(model.title);
            this.kbId(model.kbId);
            this.classification(model.classification);
            this.severity(model.severity);
            this.state(model.state);
            this.installedTime(model.installedTime);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getKBId() {
            return this.kbId;
        }

        @Override
        public final Builder kbId(String kbId) {
            this.kbId = kbId;
            return this;
        }

        public final void setKBId(String kbId) {
            this.kbId = kbId;
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PatchComplianceDataState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getInstalledTime() {
            return this.installedTime;
        }

        @Override
        public final Builder installedTime(Instant installedTime) {
            this.installedTime = installedTime;
            return this;
        }

        public final void setInstalledTime(Instant installedTime) {
            this.installedTime = installedTime;
        }

        public PatchComplianceData build() {
            return new PatchComplianceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchComplianceData> {
        public Builder title(String var1);

        public Builder kbId(String var1);

        public Builder classification(String var1);

        public Builder severity(String var1);

        public Builder state(String var1);

        public Builder state(PatchComplianceDataState var1);

        public Builder installedTime(Instant var1);
    }
}

