/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.LoggingInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoggingInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, LoggingInfo> {
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String s3Region;

    private LoggingInfo(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.s3Region = builder.s3Region;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public String s3Region() {
        return this.s3Region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingInfo)) {
            return false;
        }
        LoggingInfo other = (LoggingInfo)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.s3Region(), other.s3Region());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.s3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.s3BucketName()).append(",");
        }
        if (this.s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.s3KeyPrefix()).append(",");
        }
        if (this.s3Region() != null) {
            sb.append("S3Region: ").append(this.s3Region()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.of(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.of(clazz.cast(this.s3KeyPrefix()));
            }
            case "S3Region": {
                return Optional.of(clazz.cast(this.s3Region()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String s3KeyPrefix;
        private String s3Region;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingInfo model) {
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.s3Region(model.s3Region);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getS3Region() {
            return this.s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        public LoggingInfo build() {
            return new LoggingInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoggingInfo> {
        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder s3Region(String var1);
    }
}

