/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.DocumentFilter;
import software.amazon.awssdk.services.ssm.model.DocumentFilterListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter;
import software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDocumentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListDocumentsRequest> {
    private final List<DocumentFilter> documentFilterList;
    private final List<DocumentKeyValuesFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListDocumentsRequest(BuilderImpl builder) {
        this.documentFilterList = builder.documentFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<DocumentFilter> documentFilterList() {
        return this.documentFilterList;
    }

    public List<DocumentKeyValuesFilter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFilterList());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest)((Object)obj);
        return Objects.equals(this.documentFilterList(), other.documentFilterList()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.documentFilterList() != null) {
            sb.append("DocumentFilterList: ").append(this.documentFilterList()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentFilterList": {
                return Optional.of(clazz.cast(this.documentFilterList()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DocumentFilter> documentFilterList;
        private List<DocumentKeyValuesFilter> filters;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsRequest model) {
            this.documentFilterList(model.documentFilterList);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentFilter.Builder> getDocumentFilterList() {
            return this.documentFilterList != null ? (Collection)this.documentFilterList.stream().map(DocumentFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentFilterList(Collection<DocumentFilter> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copy(documentFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(DocumentFilter ... documentFilterList) {
            this.documentFilterList(Arrays.asList(documentFilterList));
            return this;
        }

        public final void setDocumentFilterList(Collection<DocumentFilter.BuilderImpl> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copyFromBuilder(documentFilterList);
        }

        public final Collection<DocumentKeyValuesFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(DocumentKeyValuesFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<DocumentKeyValuesFilter> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DocumentKeyValuesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<DocumentKeyValuesFilter.BuilderImpl> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDocumentsRequest build() {
            return new ListDocumentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDocumentsRequest> {
        public Builder documentFilterList(Collection<DocumentFilter> var1);

        public Builder documentFilterList(DocumentFilter ... var1);

        public Builder filters(Collection<DocumentKeyValuesFilter> var1);

        public Builder filters(DocumentKeyValuesFilter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

