/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.AssociationVersionInfo;
import software.amazon.awssdk.services.ssm.model.AssociationVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAssociationVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAssociationVersionsResponse> {
    private final List<AssociationVersionInfo> associationVersions;
    private final String nextToken;

    private ListAssociationVersionsResponse(BuilderImpl builder) {
        this.associationVersions = builder.associationVersions;
        this.nextToken = builder.nextToken;
    }

    public List<AssociationVersionInfo> associationVersions() {
        return this.associationVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationVersionsResponse)) {
            return false;
        }
        ListAssociationVersionsResponse other = (ListAssociationVersionsResponse)((Object)obj);
        return Objects.equals(this.associationVersions(), other.associationVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associationVersions() != null) {
            sb.append("AssociationVersions: ").append(this.associationVersions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationVersions": {
                return Optional.of(clazz.cast(this.associationVersions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AssociationVersionInfo> associationVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationVersionsResponse model) {
            this.associationVersions(model.associationVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssociationVersionInfo.Builder> getAssociationVersions() {
            return this.associationVersions != null ? (Collection)this.associationVersions.stream().map(AssociationVersionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associationVersions(Collection<AssociationVersionInfo> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copy(associationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationVersions(AssociationVersionInfo ... associationVersions) {
            this.associationVersions(Arrays.asList(associationVersions));
            return this;
        }

        public final void setAssociationVersions(Collection<AssociationVersionInfo.BuilderImpl> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copyFromBuilder(associationVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListAssociationVersionsResponse build() {
            return new ListAssociationVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAssociationVersionsResponse> {
        public Builder associationVersions(Collection<AssociationVersionInfo> var1);

        public Builder associationVersions(AssociationVersionInfo ... var1);

        public Builder nextToken(String var1);
    }
}

