/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.ParameterNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetParametersRequest> {
    private final List<String> names;
    private final Boolean withDecryption;

    private GetParametersRequest(BuilderImpl builder) {
        this.names = builder.names;
        this.withDecryption = builder.withDecryption;
    }

    public List<String> names() {
        return this.names;
    }

    public Boolean withDecryption() {
        return this.withDecryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.names());
        hashCode = 31 * hashCode + Objects.hashCode(this.withDecryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersRequest)) {
            return false;
        }
        GetParametersRequest other = (GetParametersRequest)((Object)obj);
        return Objects.equals(this.names(), other.names()) && Objects.equals(this.withDecryption(), other.withDecryption());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.names() != null) {
            sb.append("Names: ").append(this.names()).append(",");
        }
        if (this.withDecryption() != null) {
            sb.append("WithDecryption: ").append(this.withDecryption()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Names": {
                return Optional.of(clazz.cast(this.names()));
            }
            case "WithDecryption": {
                return Optional.of(clazz.cast(this.withDecryption()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> names;
        private Boolean withDecryption;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersRequest model) {
            this.names(model.names);
            this.withDecryption(model.withDecryption);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
        }

        public final Boolean getWithDecryption() {
            return this.withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        public GetParametersRequest build() {
            return new GetParametersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParametersRequest> {
        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder withDecryption(Boolean var1);
    }
}

