/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeregisterTargetFromMaintenanceWindowRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowRequest> {
    private final String windowId;
    private final String windowTargetId;
    private final Boolean safe;

    private DeregisterTargetFromMaintenanceWindowRequest(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.safe = builder.safe;
    }

    public String windowId() {
        return this.windowId;
    }

    public String windowTargetId() {
        return this.windowTargetId;
    }

    public Boolean safe() {
        return this.safe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.safe());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetFromMaintenanceWindowRequest)) {
            return false;
        }
        DeregisterTargetFromMaintenanceWindowRequest other = (DeregisterTargetFromMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTargetId(), other.windowTargetId()) && Objects.equals(this.safe(), other.safe());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowId() != null) {
            sb.append("WindowId: ").append(this.windowId()).append(",");
        }
        if (this.windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(this.windowTargetId()).append(",");
        }
        if (this.safe() != null) {
            sb.append("Safe: ").append(this.safe()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.of(clazz.cast(this.windowId()));
            }
            case "WindowTargetId": {
                return Optional.of(clazz.cast(this.windowTargetId()));
            }
            case "Safe": {
                return Optional.of(clazz.cast(this.safe()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTargetId;
        private Boolean safe;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTargetFromMaintenanceWindowRequest model) {
            this.windowId(model.windowId);
            this.windowTargetId(model.windowTargetId);
            this.safe(model.safe);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final Boolean getSafe() {
            return this.safe;
        }

        @Override
        public final Builder safe(Boolean safe) {
            this.safe = safe;
            return this;
        }

        public final void setSafe(Boolean safe) {
            this.safe = safe;
        }

        public DeregisterTargetFromMaintenanceWindowRequest build() {
            return new DeregisterTargetFromMaintenanceWindowRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder windowTargetId(String var1);

        public Builder safe(Boolean var1);
    }
}

