/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus;
import software.amazon.awssdk.services.ssm.transform.PatchStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchStatus> {
    private final String deploymentStatus;
    private final Instant approvalDate;

    private PatchStatus(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
        this.approvalDate = builder.approvalDate;
    }

    public PatchDeploymentStatus deploymentStatus() {
        return PatchDeploymentStatus.fromValue(this.deploymentStatus);
    }

    public String deploymentStatusString() {
        return this.deploymentStatus;
    }

    public Instant approvalDate() {
        return this.approvalDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentStatusString() == null ? 0 : this.deploymentStatusString().hashCode());
        hashCode = 31 * hashCode + (this.approvalDate() == null ? 0 : this.approvalDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchStatus)) {
            return false;
        }
        PatchStatus other = (PatchStatus)obj;
        if (other.deploymentStatusString() == null ^ this.deploymentStatusString() == null) {
            return false;
        }
        if (other.deploymentStatusString() != null && !other.deploymentStatusString().equals(this.deploymentStatusString())) {
            return false;
        }
        if (other.approvalDate() == null ^ this.approvalDate() == null) {
            return false;
        }
        return other.approvalDate() == null || other.approvalDate().equals(this.approvalDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentStatusString() != null) {
            sb.append("DeploymentStatus: ").append(this.deploymentStatusString()).append(",");
        }
        if (this.approvalDate() != null) {
            sb.append("ApprovalDate: ").append(this.approvalDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentStatus": {
                return Optional.of(clazz.cast(this.deploymentStatusString()));
            }
            case "ApprovalDate": {
                return Optional.of(clazz.cast(this.approvalDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentStatus;
        private Instant approvalDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchStatus model) {
            this.deploymentStatus(model.deploymentStatus);
            this.approvalDate(model.approvalDate);
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(PatchDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final Instant getApprovalDate() {
            return this.approvalDate;
        }

        @Override
        public final Builder approvalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public final void setApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
        }

        public PatchStatus build() {
            return new PatchStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchStatus> {
        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(PatchDeploymentStatus var1);

        public Builder approvalDate(Instant var1);
    }
}

