/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifier;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDocumentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDocumentsResponse> {
    private final List<DocumentIdentifier> documentIdentifiers;
    private final String nextToken;

    private ListDocumentsResponse(BuilderImpl builder) {
        this.documentIdentifiers = builder.documentIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public List<DocumentIdentifier> documentIdentifiers() {
        return this.documentIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.documentIdentifiers() == null ? 0 : this.documentIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsResponse)) {
            return false;
        }
        ListDocumentsResponse other = (ListDocumentsResponse)((Object)obj);
        if (other.documentIdentifiers() == null ^ this.documentIdentifiers() == null) {
            return false;
        }
        if (other.documentIdentifiers() != null && !other.documentIdentifiers().equals(this.documentIdentifiers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.documentIdentifiers() != null) {
            sb.append("DocumentIdentifiers: ").append(this.documentIdentifiers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentIdentifiers": {
                return Optional.of(clazz.cast(this.documentIdentifiers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DocumentIdentifier> documentIdentifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsResponse model) {
            this.documentIdentifiers(model.documentIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentIdentifier.Builder> getDocumentIdentifiers() {
            return this.documentIdentifiers != null ? (Collection)this.documentIdentifiers.stream().map(DocumentIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copy(documentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(DocumentIdentifier ... documentIdentifiers) {
            this.documentIdentifiers(Arrays.asList(documentIdentifiers));
            return this;
        }

        public final void setDocumentIdentifiers(Collection<DocumentIdentifier.BuilderImpl> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copyFromBuilder(documentIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDocumentsResponse build() {
            return new ListDocumentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDocumentsResponse> {
        public Builder documentIdentifiers(Collection<DocumentIdentifier> var1);

        public Builder documentIdentifiers(DocumentIdentifier ... var1);

        public Builder nextToken(String var1);
    }
}

