/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationStatusName;
import software.amazon.awssdk.services.ssm.transform.AssociationStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociationStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, AssociationStatus> {
    private final Instant dateValue;
    private final String name;
    private final String message;
    private final String additionalInfo;

    private AssociationStatus(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.name = builder.name;
        this.message = builder.message;
        this.additionalInfo = builder.additionalInfo;
    }

    public Instant date() {
        return this.dateValue;
    }

    public AssociationStatusName name() {
        return AssociationStatusName.fromValue(this.name);
    }

    public String nameString() {
        return this.name;
    }

    public String message() {
        return this.message;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.date() == null ? 0 : this.date().hashCode());
        hashCode = 31 * hashCode + (this.nameString() == null ? 0 : this.nameString().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationStatus)) {
            return false;
        }
        AssociationStatus other = (AssociationStatus)obj;
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.nameString() == null ^ this.nameString() == null) {
            return false;
        }
        if (other.nameString() != null && !other.nameString().equals(this.nameString())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        return other.additionalInfo() == null || other.additionalInfo().equals(this.additionalInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.date() != null) {
            sb.append("Date: ").append(this.date()).append(",");
        }
        if (this.nameString() != null) {
            sb.append("Name: ").append(this.nameString()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.nameString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "AdditionalInfo": {
                return Optional.of(clazz.cast(this.additionalInfo()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant dateValue;
        private String name;
        private String message;
        private String additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationStatus model) {
            this.date(model.dateValue);
            this.name(model.name);
            this.message(model.message);
            this.additionalInfo(model.additionalInfo);
        }

        public final Instant getDate() {
            return this.dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AssociationStatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public AssociationStatus build() {
            return new AssociationStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociationStatus> {
        public Builder date(Instant var1);

        public Builder name(String var1);

        public Builder name(AssociationStatusName var1);

        public Builder message(String var1);

        public Builder additionalInfo(String var1);
    }
}

