/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.Patch;

@SdkInternalApi
public class PatchMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<Instant> RELEASEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseDate").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CONTENTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentUrl").build();
    private static final MarshallingInfo<String> VENDOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Vendor").build();
    private static final MarshallingInfo<String> PRODUCTFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductFamily").build();
    private static final MarshallingInfo<String> PRODUCT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Product").build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").build();
    private static final MarshallingInfo<String> MSRCSEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MsrcSeverity").build();
    private static final MarshallingInfo<String> KBNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KbNumber").build();
    private static final MarshallingInfo<String> MSRCNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MsrcNumber").build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Language").build();
    private static final PatchMarshaller INSTANCE = new PatchMarshaller();

    public static PatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Patch patch, ProtocolMarshaller protocolMarshaller) {
        if (patch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)patch.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)patch.releaseDate(), RELEASEDATE_BINDING);
            protocolMarshaller.marshall((Object)patch.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)patch.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)patch.contentUrl(), CONTENTURL_BINDING);
            protocolMarshaller.marshall((Object)patch.vendor(), VENDOR_BINDING);
            protocolMarshaller.marshall((Object)patch.productFamily(), PRODUCTFAMILY_BINDING);
            protocolMarshaller.marshall((Object)patch.product(), PRODUCT_BINDING);
            protocolMarshaller.marshall((Object)patch.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)patch.msrcSeverity(), MSRCSEVERITY_BINDING);
            protocolMarshaller.marshall((Object)patch.kbNumber(), KBNUMBER_BINDING);
            protocolMarshaller.marshall((Object)patch.msrcNumber(), MSRCNUMBER_BINDING);
            protocolMarshaller.marshall((Object)patch.language(), LANGUAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

