/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.PatchBaselineIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchBaselineIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchBaselineIdentity> {
    private final String baselineId;
    private final String baselineName;
    private final String baselineDescription;
    private final Boolean defaultBaseline;

    private PatchBaselineIdentity(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.baselineName = builder.baselineName;
        this.baselineDescription = builder.baselineDescription;
        this.defaultBaseline = builder.defaultBaseline;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String baselineName() {
        return this.baselineName;
    }

    public String baselineDescription() {
        return this.baselineDescription;
    }

    public Boolean defaultBaseline() {
        return this.defaultBaseline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.baselineId() == null ? 0 : this.baselineId().hashCode());
        hashCode = 31 * hashCode + (this.baselineName() == null ? 0 : this.baselineName().hashCode());
        hashCode = 31 * hashCode + (this.baselineDescription() == null ? 0 : this.baselineDescription().hashCode());
        hashCode = 31 * hashCode + (this.defaultBaseline() == null ? 0 : this.defaultBaseline().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchBaselineIdentity)) {
            return false;
        }
        PatchBaselineIdentity other = (PatchBaselineIdentity)obj;
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.baselineName() == null ^ this.baselineName() == null) {
            return false;
        }
        if (other.baselineName() != null && !other.baselineName().equals(this.baselineName())) {
            return false;
        }
        if (other.baselineDescription() == null ^ this.baselineDescription() == null) {
            return false;
        }
        if (other.baselineDescription() != null && !other.baselineDescription().equals(this.baselineDescription())) {
            return false;
        }
        if (other.defaultBaseline() == null ^ this.defaultBaseline() == null) {
            return false;
        }
        return other.defaultBaseline() == null || other.defaultBaseline().equals(this.defaultBaseline());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baselineId() != null) {
            sb.append("BaselineId: ").append(this.baselineId()).append(",");
        }
        if (this.baselineName() != null) {
            sb.append("BaselineName: ").append(this.baselineName()).append(",");
        }
        if (this.baselineDescription() != null) {
            sb.append("BaselineDescription: ").append(this.baselineDescription()).append(",");
        }
        if (this.defaultBaseline() != null) {
            sb.append("DefaultBaseline: ").append(this.defaultBaseline()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchBaselineIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String baselineId;
        private String baselineName;
        private String baselineDescription;
        private Boolean defaultBaseline;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchBaselineIdentity model) {
            this.setBaselineId(model.baselineId);
            this.setBaselineName(model.baselineName);
            this.setBaselineDescription(model.baselineDescription);
            this.setDefaultBaseline(model.defaultBaseline);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getBaselineName() {
            return this.baselineName;
        }

        @Override
        public final Builder baselineName(String baselineName) {
            this.baselineName = baselineName;
            return this;
        }

        public final void setBaselineName(String baselineName) {
            this.baselineName = baselineName;
        }

        public final String getBaselineDescription() {
            return this.baselineDescription;
        }

        @Override
        public final Builder baselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
            return this;
        }

        public final void setBaselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
        }

        public final Boolean getDefaultBaseline() {
            return this.defaultBaseline;
        }

        @Override
        public final Builder defaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
            return this;
        }

        public final void setDefaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
        }

        public PatchBaselineIdentity build() {
            return new PatchBaselineIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchBaselineIdentity> {
        public Builder baselineId(String var1);

        public Builder baselineName(String var1);

        public Builder baselineDescription(String var1);

        public Builder defaultBaseline(Boolean var1);
    }
}

