/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersListCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowExecutionTaskResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskResponse> {
    private final String windowExecutionId;
    private final String taskExecutionId;
    private final String taskArn;
    private final String serviceRole;
    private final String type;
    private final List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters;
    private final Integer priority;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;

    private GetMaintenanceWindowExecutionTaskResponse(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.taskArn = builder.taskArn;
        this.serviceRole = builder.serviceRole;
        this.type = builder.type;
        this.taskParameters = builder.taskParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskExecutionId() {
        return this.taskExecutionId;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String type() {
        return this.type;
    }

    public List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters() {
        return this.taskParameters;
    }

    public Integer priority() {
        return this.priority;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public String status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowExecutionId() == null ? 0 : this.windowExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.taskExecutionId() == null ? 0 : this.taskExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.taskArn() == null ? 0 : this.taskArn().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.taskParameters() == null ? 0 : this.taskParameters().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.maxConcurrency() == null ? 0 : this.maxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.maxErrors() == null ? 0 : this.maxErrors().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskResponse other = (GetMaintenanceWindowExecutionTaskResponse)((Object)obj);
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.taskExecutionId() == null ^ this.taskExecutionId() == null) {
            return false;
        }
        if (other.taskExecutionId() != null && !other.taskExecutionId().equals(this.taskExecutionId())) {
            return false;
        }
        if (other.taskArn() == null ^ this.taskArn() == null) {
            return false;
        }
        if (other.taskArn() != null && !other.taskArn().equals(this.taskArn())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.taskParameters() == null ^ this.taskParameters() == null) {
            return false;
        }
        if (other.taskParameters() != null && !other.taskParameters().equals(this.taskParameters())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.maxConcurrency() == null ^ this.maxConcurrency() == null) {
            return false;
        }
        if (other.maxConcurrency() != null && !other.maxConcurrency().equals(this.maxConcurrency())) {
            return false;
        }
        if (other.maxErrors() == null ^ this.maxErrors() == null) {
            return false;
        }
        if (other.maxErrors() != null && !other.maxErrors().equals(this.maxErrors())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        return other.endTime() == null || other.endTime().equals(this.endTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(this.windowExecutionId()).append(",");
        }
        if (this.taskExecutionId() != null) {
            sb.append("TaskExecutionId: ").append(this.taskExecutionId()).append(",");
        }
        if (this.taskArn() != null) {
            sb.append("TaskArn: ").append(this.taskArn()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.taskParameters() != null) {
            sb.append("TaskParameters: ").append(this.taskParameters()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.maxConcurrency()).append(",");
        }
        if (this.maxErrors() != null) {
            sb.append("MaxErrors: ").append(this.maxErrors()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskExecutionId;
        private String taskArn;
        private String serviceRole;
        private String type;
        private List<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters;
        private Integer priority;
        private String maxConcurrency;
        private String maxErrors;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskResponse model) {
            this.setWindowExecutionId(model.windowExecutionId);
            this.setTaskExecutionId(model.taskExecutionId);
            this.setTaskArn(model.taskArn);
            this.setServiceRole(model.serviceRole);
            this.setType(model.type);
            this.setTaskParameters(model.taskParameters);
            this.setPriority(model.priority);
            this.setMaxConcurrency(model.maxConcurrency);
            this.setMaxErrors(model.maxErrors);
            this.setStatus(model.status);
            this.setStatusDetails(model.statusDetails);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return this.taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MaintenanceWindowTaskType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> getTaskParameters() {
            return this.taskParameters;
        }

        @Override
        public final Builder taskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersListCopier.copy(taskParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> ... taskParameters) {
            this.taskParameters(Arrays.asList(taskParameters));
            return this;
        }

        public final void setTaskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersListCopier.copy(taskParameters);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public GetMaintenanceWindowExecutionTaskResponse build() {
            return new GetMaintenanceWindowExecutionTaskResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskResponse> {
        public Builder windowExecutionId(String var1);

        public Builder taskExecutionId(String var1);

        public Builder taskArn(String var1);

        public Builder serviceRole(String var1);

        public Builder type(String var1);

        public Builder type(MaintenanceWindowTaskType var1);

        public Builder taskParameters(Collection<Map<String, MaintenanceWindowTaskParameterValueExpression>> var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> ... var1);

        public Builder priority(Integer var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

