/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationStatusAggregatedCountCopier;
import software.amazon.awssdk.services.ssm.transform.AssociationOverviewMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociationOverview
implements StructuredPojo,
ToCopyableBuilder<Builder, AssociationOverview> {
    private final String status;
    private final String detailedStatus;
    private final Map<String, Integer> associationStatusAggregatedCount;

    private AssociationOverview(BuilderImpl builder) {
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.associationStatusAggregatedCount = builder.associationStatusAggregatedCount;
    }

    public String status() {
        return this.status;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public Map<String, Integer> associationStatusAggregatedCount() {
        return this.associationStatusAggregatedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.detailedStatus() == null ? 0 : this.detailedStatus().hashCode());
        hashCode = 31 * hashCode + (this.associationStatusAggregatedCount() == null ? 0 : this.associationStatusAggregatedCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationOverview)) {
            return false;
        }
        AssociationOverview other = (AssociationOverview)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.detailedStatus() == null ^ this.detailedStatus() == null) {
            return false;
        }
        if (other.detailedStatus() != null && !other.detailedStatus().equals(this.detailedStatus())) {
            return false;
        }
        if (other.associationStatusAggregatedCount() == null ^ this.associationStatusAggregatedCount() == null) {
            return false;
        }
        return other.associationStatusAggregatedCount() == null || other.associationStatusAggregatedCount().equals(this.associationStatusAggregatedCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.detailedStatus() != null) {
            sb.append("DetailedStatus: ").append(this.detailedStatus()).append(",");
        }
        if (this.associationStatusAggregatedCount() != null) {
            sb.append("AssociationStatusAggregatedCount: ").append(this.associationStatusAggregatedCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String status;
        private String detailedStatus;
        private Map<String, Integer> associationStatusAggregatedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationOverview model) {
            this.setStatus(model.status);
            this.setDetailedStatus(model.detailedStatus);
            this.setAssociationStatusAggregatedCount(model.associationStatusAggregatedCount);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Map<String, Integer> getAssociationStatusAggregatedCount() {
            return this.associationStatusAggregatedCount;
        }

        @Override
        public final Builder associationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
            return this;
        }

        public final void setAssociationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
        }

        public AssociationOverview build() {
            return new AssociationOverview(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociationOverview> {
        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder associationStatusAggregatedCount(Map<String, Integer> var1);
    }
}

