/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentVersionInfo;

public class DocumentVersionInfoUnmarshaller
implements Unmarshaller<DocumentVersionInfo, JsonUnmarshallerContext> {
    private static final DocumentVersionInfoUnmarshaller INSTANCE = new DocumentVersionInfoUnmarshaller();

    public DocumentVersionInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        DocumentVersionInfo.Builder documentVersionInfoBuilder = DocumentVersionInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    documentVersionInfoBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DocumentVersion", targetDepth)) {
                    context.nextToken();
                    documentVersionInfoBuilder.documentVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedDate", targetDepth)) {
                    context.nextToken();
                    documentVersionInfoBuilder.createdDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("IsDefaultVersion", targetDepth)) {
                    context.nextToken();
                    documentVersionInfoBuilder.isDefaultVersion((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DocumentVersionInfo)documentVersionInfoBuilder.build();
    }

    public static DocumentVersionInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

