/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusAggregatedCountCopier;
import software.amazon.awssdk.services.ssm.transform.InstanceAggregatedAssociationOverviewMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAggregatedAssociationOverview
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAggregatedAssociationOverview> {
    private final String detailedStatus;
    private final Map<String, Integer> instanceAssociationStatusAggregatedCount;

    private InstanceAggregatedAssociationOverview(BuilderImpl builder) {
        this.detailedStatus = builder.detailedStatus;
        this.instanceAssociationStatusAggregatedCount = builder.instanceAssociationStatusAggregatedCount;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public Map<String, Integer> instanceAssociationStatusAggregatedCount() {
        return this.instanceAssociationStatusAggregatedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.detailedStatus() == null ? 0 : this.detailedStatus().hashCode());
        hashCode = 31 * hashCode + (this.instanceAssociationStatusAggregatedCount() == null ? 0 : this.instanceAssociationStatusAggregatedCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAggregatedAssociationOverview)) {
            return false;
        }
        InstanceAggregatedAssociationOverview other = (InstanceAggregatedAssociationOverview)obj;
        if (other.detailedStatus() == null ^ this.detailedStatus() == null) {
            return false;
        }
        if (other.detailedStatus() != null && !other.detailedStatus().equals(this.detailedStatus())) {
            return false;
        }
        if (other.instanceAssociationStatusAggregatedCount() == null ^ this.instanceAssociationStatusAggregatedCount() == null) {
            return false;
        }
        return other.instanceAssociationStatusAggregatedCount() == null || other.instanceAssociationStatusAggregatedCount().equals(this.instanceAssociationStatusAggregatedCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.detailedStatus() != null) {
            sb.append("DetailedStatus: ").append(this.detailedStatus()).append(",");
        }
        if (this.instanceAssociationStatusAggregatedCount() != null) {
            sb.append("InstanceAssociationStatusAggregatedCount: ").append(this.instanceAssociationStatusAggregatedCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAggregatedAssociationOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String detailedStatus;
        private Map<String, Integer> instanceAssociationStatusAggregatedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAggregatedAssociationOverview model) {
            this.setDetailedStatus(model.detailedStatus);
            this.setInstanceAssociationStatusAggregatedCount(model.instanceAssociationStatusAggregatedCount);
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Map<String, Integer> getInstanceAssociationStatusAggregatedCount() {
            return this.instanceAssociationStatusAggregatedCount;
        }

        @Override
        public final Builder instanceAssociationStatusAggregatedCount(Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier.copy(instanceAssociationStatusAggregatedCount);
            return this;
        }

        public final void setInstanceAssociationStatusAggregatedCount(Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier.copy(instanceAssociationStatusAggregatedCount);
        }

        public InstanceAggregatedAssociationOverview build() {
            return new InstanceAggregatedAssociationOverview(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAggregatedAssociationOverview> {
        public Builder detailedStatus(String var1);

        public Builder instanceAssociationStatusAggregatedCount(Map<String, Integer> var1);
    }
}

