/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.services.ssm.transform.FailureDetailsUnmarshaller;

public class StepExecutionUnmarshaller
implements Unmarshaller<StepExecution, JsonUnmarshallerContext> {
    private static StepExecutionUnmarshaller INSTANCE;

    public StepExecution unmarshall(JsonUnmarshallerContext context) throws Exception {
        StepExecution.Builder stepExecutionBuilder = StepExecution.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StepName", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.stepName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.action((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExecutionStartTime", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.executionStartTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExecutionEndTime", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.executionEndTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("StepStatus", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.stepStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResponseCode", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.responseCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Inputs", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.inputs(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Outputs", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.outputs(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("Response", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.response((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FailureMessage", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.failureMessage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FailureDetails", targetDepth)) {
                    context.nextToken();
                    stepExecutionBuilder.failureDetails(FailureDetailsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StepExecution)stepExecutionBuilder.build();
    }

    public static StepExecutionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StepExecutionUnmarshaller();
        }
        return INSTANCE;
    }
}

