/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDocumentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDocumentRequest> {
    private final String content;
    private final String name;
    private final String documentVersion;

    private UpdateDocumentRequest(BuilderImpl builder) {
        this.content = builder.content;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
    }

    public String content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.content() == null ? 0 : this.content().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentRequest)) {
            return false;
        }
        UpdateDocumentRequest other = (UpdateDocumentRequest)((Object)obj);
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        if (other.content() != null && !other.content().equals(this.content())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        return other.documentVersion() == null || other.documentVersion().equals(this.documentVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String content;
        private String name;
        private String documentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentRequest model) {
            this.setContent(model.content);
            this.setName(model.name);
            this.setDocumentVersion(model.documentVersion);
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public UpdateDocumentRequest build() {
            return new UpdateDocumentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDocumentRequest> {
        public Builder content(String var1);

        public Builder name(String var1);

        public Builder documentVersion(String var1);
    }
}

