/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchRule;
import software.amazon.awssdk.services.ssm.model.PatchRuleListCopier;
import software.amazon.awssdk.services.ssm.transform.PatchRuleGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchRuleGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchRuleGroup> {
    private final List<PatchRule> patchRules;

    private PatchRuleGroup(BuilderImpl builder) {
        this.patchRules = builder.patchRules;
    }

    public List<PatchRule> patchRules() {
        return this.patchRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.patchRules() == null ? 0 : this.patchRules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRuleGroup)) {
            return false;
        }
        PatchRuleGroup other = (PatchRuleGroup)obj;
        if (other.patchRules() == null ^ this.patchRules() == null) {
            return false;
        }
        return other.patchRules() == null || other.patchRules().equals(this.patchRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.patchRules() != null) {
            sb.append("PatchRules: ").append(this.patchRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchRuleGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PatchRule> patchRules;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRuleGroup model) {
            this.setPatchRules(model.patchRules);
        }

        public final Collection<PatchRule> getPatchRules() {
            return this.patchRules;
        }

        @Override
        public final Builder patchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchRules(PatchRule ... patchRules) {
            this.patchRules(Arrays.asList(patchRules));
            return this;
        }

        public final void setPatchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
        }

        @SafeVarargs
        public final void setPatchRules(PatchRule ... patchRules) {
            this.patchRules(Arrays.asList(patchRules));
        }

        public PatchRuleGroup build() {
            return new PatchRuleGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchRuleGroup> {
        public Builder patchRules(Collection<PatchRule> var1);

        public Builder patchRules(PatchRule ... var1);
    }
}

