/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchOperationType;
import software.amazon.awssdk.services.ssm.transform.InstancePatchStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstancePatchState
implements StructuredPojo,
ToCopyableBuilder<Builder, InstancePatchState> {
    private final String instanceId;
    private final String patchGroup;
    private final String baselineId;
    private final String snapshotId;
    private final String ownerInformation;
    private final Integer installedCount;
    private final Integer installedOtherCount;
    private final Integer missingCount;
    private final Integer failedCount;
    private final Integer notApplicableCount;
    private final Instant operationStartTime;
    private final Instant operationEndTime;
    private final String operation;

    private InstancePatchState(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.patchGroup = builder.patchGroup;
        this.baselineId = builder.baselineId;
        this.snapshotId = builder.snapshotId;
        this.ownerInformation = builder.ownerInformation;
        this.installedCount = builder.installedCount;
        this.installedOtherCount = builder.installedOtherCount;
        this.missingCount = builder.missingCount;
        this.failedCount = builder.failedCount;
        this.notApplicableCount = builder.notApplicableCount;
        this.operationStartTime = builder.operationStartTime;
        this.operationEndTime = builder.operationEndTime;
        this.operation = builder.operation;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String patchGroup() {
        return this.patchGroup;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public Integer installedCount() {
        return this.installedCount;
    }

    public Integer installedOtherCount() {
        return this.installedOtherCount;
    }

    public Integer missingCount() {
        return this.missingCount;
    }

    public Integer failedCount() {
        return this.failedCount;
    }

    public Integer notApplicableCount() {
        return this.notApplicableCount;
    }

    public Instant operationStartTime() {
        return this.operationStartTime;
    }

    public Instant operationEndTime() {
        return this.operationEndTime;
    }

    public String operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.patchGroup() == null ? 0 : this.patchGroup().hashCode());
        hashCode = 31 * hashCode + (this.baselineId() == null ? 0 : this.baselineId().hashCode());
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        hashCode = 31 * hashCode + (this.ownerInformation() == null ? 0 : this.ownerInformation().hashCode());
        hashCode = 31 * hashCode + (this.installedCount() == null ? 0 : this.installedCount().hashCode());
        hashCode = 31 * hashCode + (this.installedOtherCount() == null ? 0 : this.installedOtherCount().hashCode());
        hashCode = 31 * hashCode + (this.missingCount() == null ? 0 : this.missingCount().hashCode());
        hashCode = 31 * hashCode + (this.failedCount() == null ? 0 : this.failedCount().hashCode());
        hashCode = 31 * hashCode + (this.notApplicableCount() == null ? 0 : this.notApplicableCount().hashCode());
        hashCode = 31 * hashCode + (this.operationStartTime() == null ? 0 : this.operationStartTime().hashCode());
        hashCode = 31 * hashCode + (this.operationEndTime() == null ? 0 : this.operationEndTime().hashCode());
        hashCode = 31 * hashCode + (this.operation() == null ? 0 : this.operation().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePatchState)) {
            return false;
        }
        InstancePatchState other = (InstancePatchState)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.patchGroup() == null ^ this.patchGroup() == null) {
            return false;
        }
        if (other.patchGroup() != null && !other.patchGroup().equals(this.patchGroup())) {
            return false;
        }
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.ownerInformation() == null ^ this.ownerInformation() == null) {
            return false;
        }
        if (other.ownerInformation() != null && !other.ownerInformation().equals(this.ownerInformation())) {
            return false;
        }
        if (other.installedCount() == null ^ this.installedCount() == null) {
            return false;
        }
        if (other.installedCount() != null && !other.installedCount().equals(this.installedCount())) {
            return false;
        }
        if (other.installedOtherCount() == null ^ this.installedOtherCount() == null) {
            return false;
        }
        if (other.installedOtherCount() != null && !other.installedOtherCount().equals(this.installedOtherCount())) {
            return false;
        }
        if (other.missingCount() == null ^ this.missingCount() == null) {
            return false;
        }
        if (other.missingCount() != null && !other.missingCount().equals(this.missingCount())) {
            return false;
        }
        if (other.failedCount() == null ^ this.failedCount() == null) {
            return false;
        }
        if (other.failedCount() != null && !other.failedCount().equals(this.failedCount())) {
            return false;
        }
        if (other.notApplicableCount() == null ^ this.notApplicableCount() == null) {
            return false;
        }
        if (other.notApplicableCount() != null && !other.notApplicableCount().equals(this.notApplicableCount())) {
            return false;
        }
        if (other.operationStartTime() == null ^ this.operationStartTime() == null) {
            return false;
        }
        if (other.operationStartTime() != null && !other.operationStartTime().equals(this.operationStartTime())) {
            return false;
        }
        if (other.operationEndTime() == null ^ this.operationEndTime() == null) {
            return false;
        }
        if (other.operationEndTime() != null && !other.operationEndTime().equals(this.operationEndTime())) {
            return false;
        }
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        return other.operation() == null || other.operation().equals(this.operation());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.patchGroup() != null) {
            sb.append("PatchGroup: ").append(this.patchGroup()).append(",");
        }
        if (this.baselineId() != null) {
            sb.append("BaselineId: ").append(this.baselineId()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(this.ownerInformation()).append(",");
        }
        if (this.installedCount() != null) {
            sb.append("InstalledCount: ").append(this.installedCount()).append(",");
        }
        if (this.installedOtherCount() != null) {
            sb.append("InstalledOtherCount: ").append(this.installedOtherCount()).append(",");
        }
        if (this.missingCount() != null) {
            sb.append("MissingCount: ").append(this.missingCount()).append(",");
        }
        if (this.failedCount() != null) {
            sb.append("FailedCount: ").append(this.failedCount()).append(",");
        }
        if (this.notApplicableCount() != null) {
            sb.append("NotApplicableCount: ").append(this.notApplicableCount()).append(",");
        }
        if (this.operationStartTime() != null) {
            sb.append("OperationStartTime: ").append(this.operationStartTime()).append(",");
        }
        if (this.operationEndTime() != null) {
            sb.append("OperationEndTime: ").append(this.operationEndTime()).append(",");
        }
        if (this.operation() != null) {
            sb.append("Operation: ").append(this.operation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancePatchStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String patchGroup;
        private String baselineId;
        private String snapshotId;
        private String ownerInformation;
        private Integer installedCount;
        private Integer installedOtherCount;
        private Integer missingCount;
        private Integer failedCount;
        private Integer notApplicableCount;
        private Instant operationStartTime;
        private Instant operationEndTime;
        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePatchState model) {
            this.setInstanceId(model.instanceId);
            this.setPatchGroup(model.patchGroup);
            this.setBaselineId(model.baselineId);
            this.setSnapshotId(model.snapshotId);
            this.setOwnerInformation(model.ownerInformation);
            this.setInstalledCount(model.installedCount);
            this.setInstalledOtherCount(model.installedOtherCount);
            this.setMissingCount(model.missingCount);
            this.setFailedCount(model.failedCount);
            this.setNotApplicableCount(model.notApplicableCount);
            this.setOperationStartTime(model.operationStartTime);
            this.setOperationEndTime(model.operationEndTime);
            this.setOperation(model.operation);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final Integer getInstalledCount() {
            return this.installedCount;
        }

        @Override
        public final Builder installedCount(Integer installedCount) {
            this.installedCount = installedCount;
            return this;
        }

        public final void setInstalledCount(Integer installedCount) {
            this.installedCount = installedCount;
        }

        public final Integer getInstalledOtherCount() {
            return this.installedOtherCount;
        }

        @Override
        public final Builder installedOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
            return this;
        }

        public final void setInstalledOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
        }

        public final Integer getMissingCount() {
            return this.missingCount;
        }

        @Override
        public final Builder missingCount(Integer missingCount) {
            this.missingCount = missingCount;
            return this;
        }

        public final void setMissingCount(Integer missingCount) {
            this.missingCount = missingCount;
        }

        public final Integer getFailedCount() {
            return this.failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        public final Integer getNotApplicableCount() {
            return this.notApplicableCount;
        }

        @Override
        public final Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            return this;
        }

        public final void setNotApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
        }

        public final Instant getOperationStartTime() {
            return this.operationStartTime;
        }

        @Override
        public final Builder operationStartTime(Instant operationStartTime) {
            this.operationStartTime = operationStartTime;
            return this;
        }

        public final void setOperationStartTime(Instant operationStartTime) {
            this.operationStartTime = operationStartTime;
        }

        public final Instant getOperationEndTime() {
            return this.operationEndTime;
        }

        @Override
        public final Builder operationEndTime(Instant operationEndTime) {
            this.operationEndTime = operationEndTime;
            return this;
        }

        public final void setOperationEndTime(Instant operationEndTime) {
            this.operationEndTime = operationEndTime;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(PatchOperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final void setOperation(PatchOperationType operation) {
            this.operation(operation.toString());
        }

        public InstancePatchState build() {
            return new InstancePatchState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstancePatchState> {
        public Builder instanceId(String var1);

        public Builder patchGroup(String var1);

        public Builder baselineId(String var1);

        public Builder snapshotId(String var1);

        public Builder ownerInformation(String var1);

        public Builder installedCount(Integer var1);

        public Builder installedOtherCount(Integer var1);

        public Builder missingCount(Integer var1);

        public Builder failedCount(Integer var1);

        public Builder notApplicableCount(Integer var1);

        public Builder operationStartTime(Instant var1);

        public Builder operationEndTime(Instant var1);

        public Builder operation(String var1);

        public Builder operation(PatchOperationType var1);
    }
}

