/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.DocumentParameter;
import software.amazon.awssdk.services.ssm.model.DocumentParameterListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentStatus;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.PlatformTypeListCopier;
import software.amazon.awssdk.services.ssm.transform.DocumentDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentDescription> {
    private final String sha1;
    private final String hash;
    private final String hashType;
    private final String name;
    private final String owner;
    private final Instant createdDate;
    private final String status;
    private final String documentVersion;
    private final String description;
    private final List<DocumentParameter> parameters;
    private final List<String> platformTypes;
    private final String documentType;
    private final String schemaVersion;
    private final String latestVersion;
    private final String defaultVersion;

    private DocumentDescription(BuilderImpl builder) {
        this.sha1 = builder.sha1;
        this.hash = builder.hash;
        this.hashType = builder.hashType;
        this.name = builder.name;
        this.owner = builder.owner;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.documentVersion = builder.documentVersion;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.platformTypes = builder.platformTypes;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
        this.latestVersion = builder.latestVersion;
        this.defaultVersion = builder.defaultVersion;
    }

    public String sha1() {
        return this.sha1;
    }

    public String hash() {
        return this.hash;
    }

    public String hashType() {
        return this.hashType;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String status() {
        return this.status;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String description() {
        return this.description;
    }

    public List<DocumentParameter> parameters() {
        return this.parameters;
    }

    public List<String> platformTypes() {
        return this.platformTypes;
    }

    public String documentType() {
        return this.documentType;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sha1() == null ? 0 : this.sha1().hashCode());
        hashCode = 31 * hashCode + (this.hash() == null ? 0 : this.hash().hashCode());
        hashCode = 31 * hashCode + (this.hashType() == null ? 0 : this.hashType().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.createdDate() == null ? 0 : this.createdDate().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.platformTypes() == null ? 0 : this.platformTypes().hashCode());
        hashCode = 31 * hashCode + (this.documentType() == null ? 0 : this.documentType().hashCode());
        hashCode = 31 * hashCode + (this.schemaVersion() == null ? 0 : this.schemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.latestVersion() == null ? 0 : this.latestVersion().hashCode());
        hashCode = 31 * hashCode + (this.defaultVersion() == null ? 0 : this.defaultVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription)obj;
        if (other.sha1() == null ^ this.sha1() == null) {
            return false;
        }
        if (other.sha1() != null && !other.sha1().equals(this.sha1())) {
            return false;
        }
        if (other.hash() == null ^ this.hash() == null) {
            return false;
        }
        if (other.hash() != null && !other.hash().equals(this.hash())) {
            return false;
        }
        if (other.hashType() == null ^ this.hashType() == null) {
            return false;
        }
        if (other.hashType() != null && !other.hashType().equals(this.hashType())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.platformTypes() == null ^ this.platformTypes() == null) {
            return false;
        }
        if (other.platformTypes() != null && !other.platformTypes().equals(this.platformTypes())) {
            return false;
        }
        if (other.documentType() == null ^ this.documentType() == null) {
            return false;
        }
        if (other.documentType() != null && !other.documentType().equals(this.documentType())) {
            return false;
        }
        if (other.schemaVersion() == null ^ this.schemaVersion() == null) {
            return false;
        }
        if (other.schemaVersion() != null && !other.schemaVersion().equals(this.schemaVersion())) {
            return false;
        }
        if (other.latestVersion() == null ^ this.latestVersion() == null) {
            return false;
        }
        if (other.latestVersion() != null && !other.latestVersion().equals(this.latestVersion())) {
            return false;
        }
        if (other.defaultVersion() == null ^ this.defaultVersion() == null) {
            return false;
        }
        return other.defaultVersion() == null || other.defaultVersion().equals(this.defaultVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sha1() != null) {
            sb.append("Sha1: ").append(this.sha1()).append(",");
        }
        if (this.hash() != null) {
            sb.append("Hash: ").append(this.hash()).append(",");
        }
        if (this.hashType() != null) {
            sb.append("HashType: ").append(this.hashType()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.platformTypes() != null) {
            sb.append("PlatformTypes: ").append(this.platformTypes()).append(",");
        }
        if (this.documentType() != null) {
            sb.append("DocumentType: ").append(this.documentType()).append(",");
        }
        if (this.schemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.schemaVersion()).append(",");
        }
        if (this.latestVersion() != null) {
            sb.append("LatestVersion: ").append(this.latestVersion()).append(",");
        }
        if (this.defaultVersion() != null) {
            sb.append("DefaultVersion: ").append(this.defaultVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String sha1;
        private String hash;
        private String hashType;
        private String name;
        private String owner;
        private Instant createdDate;
        private String status;
        private String documentVersion;
        private String description;
        private List<DocumentParameter> parameters;
        private List<String> platformTypes;
        private String documentType;
        private String schemaVersion;
        private String latestVersion;
        private String defaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDescription model) {
            this.setSha1(model.sha1);
            this.setHash(model.hash);
            this.setHashType(model.hashType);
            this.setName(model.name);
            this.setOwner(model.owner);
            this.setCreatedDate(model.createdDate);
            this.setStatus(model.status);
            this.setDocumentVersion(model.documentVersion);
            this.setDescription(model.description);
            this.setParameters(model.parameters);
            this.setPlatformTypes(model.platformTypes);
            this.setDocumentType(model.documentType);
            this.setSchemaVersion(model.schemaVersion);
            this.setLatestVersion(model.latestVersion);
            this.setDefaultVersion(model.defaultVersion);
        }

        public final String getSha1() {
            return this.sha1;
        }

        @Override
        public final Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public final void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public final String getHash() {
            return this.hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        public final String getHashType() {
            return this.hashType;
        }

        @Override
        public final Builder hashType(String hashType) {
            this.hashType = hashType;
            return this;
        }

        @Override
        public final Builder hashType(DocumentHashType hashType) {
            this.hashType(hashType.toString());
            return this;
        }

        public final void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public final void setHashType(DocumentHashType hashType) {
            this.hashType(hashType.toString());
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(DocumentStatus status) {
            this.status(status.toString());
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DocumentParameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<DocumentParameter> parameters) {
            this.parameters = DocumentParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(DocumentParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<DocumentParameter> parameters) {
            this.parameters = DocumentParameterListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(DocumentParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
        }

        public final Collection<String> getPlatformTypes() {
            return this.platformTypes;
        }

        @Override
        public final Builder platformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(String ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(PlatformType ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        @SafeVarargs
        public final void setPlatformTypes(String ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
        }

        @SafeVarargs
        public final void setPlatformTypes(PlatformType ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final void setDocumentType(DocumentType documentType) {
            this.documentType(documentType.toString());
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final String getDefaultVersion() {
            return this.defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public DocumentDescription build() {
            return new DocumentDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentDescription> {
        public Builder sha1(String var1);

        public Builder hash(String var1);

        public Builder hashType(String var1);

        public Builder hashType(DocumentHashType var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder createdDate(Instant var1);

        public Builder status(String var1);

        public Builder status(DocumentStatus var1);

        public Builder documentVersion(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<DocumentParameter> var1);

        public Builder parameters(DocumentParameter ... var1);

        public Builder platformTypes(Collection<String> var1);

        public Builder platformTypes(String ... var1);

        public Builder platformTypes(PlatformType ... var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder schemaVersion(String var1);

        public Builder latestVersion(String var1);

        public Builder defaultVersion(String var1);
    }
}

