/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMapping;
import software.amazon.awssdk.services.ssm.model.PatchGroupPatchBaselineMappingListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePatchGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePatchGroupsResponse> {
    private final List<PatchGroupPatchBaselineMapping> mappings;
    private final String nextToken;

    private DescribePatchGroupsResponse(BuilderImpl builder) {
        this.mappings = builder.mappings;
        this.nextToken = builder.nextToken;
    }

    public List<PatchGroupPatchBaselineMapping> mappings() {
        return this.mappings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mappings() == null ? 0 : this.mappings().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupsResponse)) {
            return false;
        }
        DescribePatchGroupsResponse other = (DescribePatchGroupsResponse)((Object)obj);
        if (other.mappings() == null ^ this.mappings() == null) {
            return false;
        }
        if (other.mappings() != null && !other.mappings().equals(this.mappings())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mappings() != null) {
            sb.append("Mappings: ").append(this.mappings()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PatchGroupPatchBaselineMapping> mappings;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupsResponse model) {
            this.setMappings(model.mappings);
            this.setNextToken(model.nextToken);
        }

        public final Collection<PatchGroupPatchBaselineMapping> getMappings() {
            return this.mappings;
        }

        @Override
        public final Builder mappings(Collection<PatchGroupPatchBaselineMapping> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copy(mappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappings(PatchGroupPatchBaselineMapping ... mappings) {
            this.mappings(Arrays.asList(mappings));
            return this;
        }

        public final void setMappings(Collection<PatchGroupPatchBaselineMapping> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copy(mappings);
        }

        @SafeVarargs
        public final void setMappings(PatchGroupPatchBaselineMapping ... mappings) {
            this.mappings(Arrays.asList(mappings));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribePatchGroupsResponse build() {
            return new DescribePatchGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePatchGroupsResponse> {
        public Builder mappings(Collection<PatchGroupPatchBaselineMapping> var1);

        public Builder mappings(PatchGroupPatchBaselineMapping ... var1);

        public Builder nextToken(String var1);
    }
}

