/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.AssociationDescription;
import software.amazon.awssdk.services.ssm.model.AssociationDescriptionListCopier;
import software.amazon.awssdk.services.ssm.model.FailedCreateAssociation;
import software.amazon.awssdk.services.ssm.model.FailedCreateAssociationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAssociationBatchResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateAssociationBatchResponse> {
    private final List<AssociationDescription> successful;
    private final List<FailedCreateAssociation> failed;

    private CreateAssociationBatchResponse(BuilderImpl builder) {
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public List<AssociationDescription> successful() {
        return this.successful;
    }

    public List<FailedCreateAssociation> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.successful() == null ? 0 : this.successful().hashCode());
        hashCode = 31 * hashCode + (this.failed() == null ? 0 : this.failed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchResponse)) {
            return false;
        }
        CreateAssociationBatchResponse other = (CreateAssociationBatchResponse)((Object)obj);
        if (other.successful() == null ^ this.successful() == null) {
            return false;
        }
        if (other.successful() != null && !other.successful().equals(this.successful())) {
            return false;
        }
        if (other.failed() == null ^ this.failed() == null) {
            return false;
        }
        return other.failed() == null || other.failed().equals(this.failed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.successful() != null) {
            sb.append("Successful: ").append(this.successful()).append(",");
        }
        if (this.failed() != null) {
            sb.append("Failed: ").append(this.failed()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AssociationDescription> successful;
        private List<FailedCreateAssociation> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchResponse model) {
            this.setSuccessful(model.successful);
            this.setFailed(model.failed);
        }

        public final Collection<AssociationDescription> getSuccessful() {
            return this.successful;
        }

        @Override
        public final Builder successful(Collection<AssociationDescription> successful) {
            this.successful = AssociationDescriptionListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(AssociationDescription ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<AssociationDescription> successful) {
            this.successful = AssociationDescriptionListCopier.copy(successful);
        }

        @SafeVarargs
        public final void setSuccessful(AssociationDescription ... successful) {
            this.successful(Arrays.asList(successful));
        }

        public final Collection<FailedCreateAssociation> getFailed() {
            return this.failed;
        }

        @Override
        public final Builder failed(Collection<FailedCreateAssociation> failed) {
            this.failed = FailedCreateAssociationListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(FailedCreateAssociation ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        public final void setFailed(Collection<FailedCreateAssociation> failed) {
            this.failed = FailedCreateAssociationListCopier.copy(failed);
        }

        @SafeVarargs
        public final void setFailed(FailedCreateAssociation ... failed) {
            this.failed(Arrays.asList(failed));
        }

        public CreateAssociationBatchResponse build() {
            return new CreateAssociationBatchResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAssociationBatchResponse> {
        public Builder successful(Collection<AssociationDescription> var1);

        public Builder successful(AssociationDescription ... var1);

        public Builder failed(Collection<FailedCreateAssociation> var1);

        public Builder failed(FailedCreateAssociation ... var1);
    }
}

