/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.Patch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PatchMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<Instant> RELEASEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseDate").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentUrl").isBinary(false).build();
    private static final MarshallingInfo<String> VENDOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Vendor").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductFamily").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Product").isBinary(false).build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").isBinary(false).build();
    private static final MarshallingInfo<String> MSRCSEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MsrcSeverity").isBinary(false).build();
    private static final MarshallingInfo<String> KBNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KbNumber").isBinary(false).build();
    private static final MarshallingInfo<String> MSRCNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MsrcNumber").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Language").isBinary(false).build();
    private static final PatchMarshaller INSTANCE = new PatchMarshaller();

    private PatchMarshaller() {
    }

    public static PatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Patch patch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)patch, (String)"patch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)patch.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)patch.releaseDate(), RELEASEDATE_BINDING);
            protocolMarshaller.marshall((Object)patch.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)patch.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)patch.contentUrl(), CONTENTURL_BINDING);
            protocolMarshaller.marshall((Object)patch.vendor(), VENDOR_BINDING);
            protocolMarshaller.marshall((Object)patch.productFamily(), PRODUCTFAMILY_BINDING);
            protocolMarshaller.marshall((Object)patch.product(), PRODUCT_BINDING);
            protocolMarshaller.marshall((Object)patch.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)patch.msrcSeverity(), MSRCSEVERITY_BINDING);
            protocolMarshaller.marshall((Object)patch.kbNumber(), KBNUMBER_BINDING);
            protocolMarshaller.marshall((Object)patch.msrcNumber(), MSRCNUMBER_BINDING);
            protocolMarshaller.marshall((Object)patch.language(), LANGUAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

