/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentDescriptionMarshaller {
    private static final MarshallingInfo<String> SHA1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sha1").isBinary(false).build();
    private static final MarshallingInfo<String> HASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hash").isBinary(false).build();
    private static final MarshallingInfo<String> HASHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HashType").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<List> PLATFORMTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformTypes").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").isBinary(false).build();
    private static final MarshallingInfo<String> LATESTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultVersion").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final DocumentDescriptionMarshaller INSTANCE = new DocumentDescriptionMarshaller();

    private DocumentDescriptionMarshaller() {
    }

    public static DocumentDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentDescription documentDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentDescription, (String)"documentDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentDescription.sha1(), SHA1_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.hash(), HASH_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.hashTypeAsString(), HASHTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(documentDescription.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(documentDescription.platformTypesAsStrings(), PLATFORMTYPES_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.documentTypeAsString(), DOCUMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.latestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.defaultVersion(), DEFAULTVERSION_BINDING);
            protocolMarshaller.marshall(documentDescription.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

