/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AssociationFilter;
import software.amazon.awssdk.services.ssm.model.AssociationFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociationsRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, ListAssociationsRequest> {
    private final List<AssociationFilter> associationFilterList;
    private final Integer maxResults;
    private final String nextToken;

    private ListAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.associationFilterList = builder.associationFilterList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<AssociationFilter> associationFilterList() {
        return this.associationFilterList;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationFilterList());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsRequest)) {
            return false;
        }
        ListAssociationsRequest other = (ListAssociationsRequest)((Object)obj);
        return Objects.equals(this.associationFilterList(), other.associationFilterList()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAssociationsRequest").add("AssociationFilterList", this.associationFilterList()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationFilterList": {
                return Optional.ofNullable(clazz.cast(this.associationFilterList()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<AssociationFilter> associationFilterList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationsRequest model) {
            super(model);
            this.associationFilterList(model.associationFilterList);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssociationFilter.Builder> getAssociationFilterList() {
            return this.associationFilterList != null ? (Collection)this.associationFilterList.stream().map(AssociationFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associationFilterList(Collection<AssociationFilter> associationFilterList) {
            this.associationFilterList = AssociationFilterListCopier.copy(associationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationFilterList(AssociationFilter ... associationFilterList) {
            this.associationFilterList(Arrays.asList(associationFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationFilterList(Consumer<AssociationFilter.Builder> ... associationFilterList) {
            this.associationFilterList(Stream.of(associationFilterList).map(c -> (AssociationFilter)((AssociationFilter.Builder)AssociationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociationFilterList(Collection<AssociationFilter.BuilderImpl> associationFilterList) {
            this.associationFilterList = AssociationFilterListCopier.copyFromBuilder(associationFilterList);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssociationsRequest build() {
            return new ListAssociationsRequest(this);
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    CopyableBuilder<Builder, ListAssociationsRequest> {
        public Builder associationFilterList(Collection<AssociationFilter> var1);

        public Builder associationFilterList(AssociationFilter ... var1);

        public Builder associationFilterList(Consumer<AssociationFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

