/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.EffectivePatch;
import software.amazon.awssdk.services.ssm.model.EffectivePatchListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEffectivePatchesForPatchBaselineResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeEffectivePatchesForPatchBaselineResponse> {
    private final List<EffectivePatch> effectivePatches;
    private final String nextToken;

    private DescribeEffectivePatchesForPatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.effectivePatches = builder.effectivePatches;
        this.nextToken = builder.nextToken;
    }

    public List<EffectivePatch> effectivePatches() {
        return this.effectivePatches;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.effectivePatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectivePatchesForPatchBaselineResponse)) {
            return false;
        }
        DescribeEffectivePatchesForPatchBaselineResponse other = (DescribeEffectivePatchesForPatchBaselineResponse)((Object)obj);
        return Objects.equals(this.effectivePatches(), other.effectivePatches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEffectivePatchesForPatchBaselineResponse").add("EffectivePatches", this.effectivePatches()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EffectivePatches": {
                return Optional.ofNullable(clazz.cast(this.effectivePatches()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<EffectivePatch> effectivePatches = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectivePatchesForPatchBaselineResponse model) {
            super(model);
            this.effectivePatches(model.effectivePatches);
            this.nextToken(model.nextToken);
        }

        public final Collection<EffectivePatch.Builder> getEffectivePatches() {
            return this.effectivePatches != null ? (Collection)this.effectivePatches.stream().map(EffectivePatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder effectivePatches(Collection<EffectivePatch> effectivePatches) {
            this.effectivePatches = EffectivePatchListCopier.copy(effectivePatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePatches(EffectivePatch ... effectivePatches) {
            this.effectivePatches(Arrays.asList(effectivePatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectivePatches(Consumer<EffectivePatch.Builder> ... effectivePatches) {
            this.effectivePatches(Stream.of(effectivePatches).map(c -> (EffectivePatch)((EffectivePatch.Builder)EffectivePatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEffectivePatches(Collection<EffectivePatch.BuilderImpl> effectivePatches) {
            this.effectivePatches = EffectivePatchListCopier.copyFromBuilder(effectivePatches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEffectivePatchesForPatchBaselineResponse build() {
            return new DescribeEffectivePatchesForPatchBaselineResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, DescribeEffectivePatchesForPatchBaselineResponse> {
        public Builder effectivePatches(Collection<EffectivePatch> var1);

        public Builder effectivePatches(EffectivePatch ... var1);

        public Builder effectivePatches(Consumer<EffectivePatch.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

