/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeInstancePatchStatesRequestModelMarshaller {
    private static final MarshallingInfo<List> INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIds").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final DescribeInstancePatchStatesRequestModelMarshaller INSTANCE = new DescribeInstancePatchStatesRequestModelMarshaller();

    private DescribeInstancePatchStatesRequestModelMarshaller() {
    }

    public static DescribeInstancePatchStatesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeInstancePatchStatesRequest), (String)"describeInstancePatchStatesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeInstancePatchStatesRequest.instanceIds(), INSTANCEIDS_BINDING);
            protocolMarshaller.marshall((Object)describeInstancePatchStatesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeInstancePatchStatesRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

