/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AssociationStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssociationStatusMarshaller {
    private static final MarshallingInfo<Instant> DATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Date").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<String> ADDITIONALINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalInfo").isBinary(false).build();
    private static final AssociationStatusMarshaller INSTANCE = new AssociationStatusMarshaller();

    private AssociationStatusMarshaller() {
    }

    public static AssociationStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociationStatus associationStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)associationStatus, (String)"associationStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)associationStatus.date(), DATE_BINDING);
            protocolMarshaller.marshall((Object)associationStatus.nameAsString(), NAME_BINDING);
            protocolMarshaller.marshall((Object)associationStatus.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)associationStatus.additionalInfo(), ADDITIONALINFO_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

