/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.Association;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;

public class ListAssociationsIterable
implements SdkIterable<ListAssociationsResponse> {
    private final SsmClient client;
    private final ListAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociationsIterable(SsmClient client, ListAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssociationsResponseFetcher();
    }

    public Iterator<ListAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Association> associations() {
        Function<ListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListAssociationsIterable resume(ListAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAssociationsIterable(this.client, (ListAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAssociationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAssociationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAssociationsResponseFetcher
    implements SyncPageFetcher<ListAssociationsResponse> {
        private ListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListAssociationsResponse nextPage(ListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationsIterable.this.client.listAssociations(ListAssociationsIterable.this.firstRequest);
            }
            return ListAssociationsIterable.this.client.listAssociations((ListAssociationsRequest)((Object)ListAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

