/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowLambdaParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowLambdaParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
    private final String clientContext;
    private final String qualifier;
    private final SdkBytes payload;

    private MaintenanceWindowLambdaParameters(BuilderImpl builder) {
        this.clientContext = builder.clientContext;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    public String clientContext() {
        return this.clientContext;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public SdkBytes payload() {
        return this.payload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowLambdaParameters)) {
            return false;
        }
        MaintenanceWindowLambdaParameters other = (MaintenanceWindowLambdaParameters)obj;
        return Objects.equals(this.clientContext(), other.clientContext()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        return ToString.builder((String)"MaintenanceWindowLambdaParameters").add("ClientContext", (Object)this.clientContext()).add("Qualifier", (Object)this.qualifier()).add("Payload", (Object)this.payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientContext": {
                return Optional.ofNullable(clazz.cast(this.clientContext()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowLambdaParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientContext;
        private String qualifier;
        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowLambdaParameters model) {
            this.clientContext(model.clientContext);
            this.qualifier(model.qualifier);
            this.payload(model.payload);
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = StandardMemberCopier.copy((SdkBytes)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        public MaintenanceWindowLambdaParameters build() {
            return new MaintenanceWindowLambdaParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowLambdaParameters> {
        public Builder clientContext(String var1);

        public Builder qualifier(String var1);

        public Builder payload(SdkBytes var1);
    }
}

