/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowIdentityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowIdentity> {
    private final String windowId;
    private final String name;
    private final String description;
    private final Boolean enabled;
    private final Integer duration;
    private final Integer cutoff;

    private MaintenanceWindowIdentity(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
    }

    public String windowId() {
        return this.windowId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer duration() {
        return this.duration;
    }

    public Integer cutoff() {
        return this.cutoff;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowIdentity)) {
            return false;
        }
        MaintenanceWindowIdentity other = (MaintenanceWindowIdentity)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff());
    }

    public String toString() {
        return ToString.builder((String)"MaintenanceWindowIdentity").add("WindowId", (Object)this.windowId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Enabled", (Object)this.enabled()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.ofNullable(clazz.cast(this.cutoff()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String name;
        private String description;
        private Boolean enabled;
        private Integer duration;
        private Integer cutoff;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowIdentity model) {
            this.windowId(model.windowId);
            this.name(model.name);
            this.description(model.description);
            this.enabled(model.enabled);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public MaintenanceWindowIdentity build() {
            return new MaintenanceWindowIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowIdentity> {
        public Builder windowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enabled(Boolean var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);
    }
}

