/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryAggregatorListCopier;
import software.amazon.awssdk.services.ssm.transform.InventoryAggregatorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryAggregator
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryAggregator> {
    private final String expression;
    private final List<InventoryAggregator> aggregators;

    private InventoryAggregator(BuilderImpl builder) {
        this.expression = builder.expression;
        this.aggregators = builder.aggregators;
    }

    public String expression() {
        return this.expression;
    }

    public List<InventoryAggregator> aggregators() {
        return this.aggregators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregators());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryAggregator)) {
            return false;
        }
        InventoryAggregator other = (InventoryAggregator)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.aggregators(), other.aggregators());
    }

    public String toString() {
        return ToString.builder((String)"InventoryAggregator").add("Expression", (Object)this.expression()).add("Aggregators", this.aggregators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "Aggregators": {
                return Optional.ofNullable(clazz.cast(this.aggregators()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryAggregatorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private List<InventoryAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryAggregator model) {
            this.expression(model.expression);
            this.aggregators(model.aggregators);
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final Collection<Builder> getAggregators() {
            return this.aggregators != null ? (Collection)this.aggregators.stream().map(InventoryAggregator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregators(Collection<InventoryAggregator> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(InventoryAggregator ... aggregators) {
            this.aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder> ... aggregators) {
            this.aggregators(Stream.of(aggregators).map(c -> (InventoryAggregator)((Builder)InventoryAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copyFromBuilder(aggregators);
        }

        public InventoryAggregator build() {
            return new InventoryAggregator(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryAggregator> {
        public Builder expression(String var1);

        public Builder aggregators(Collection<InventoryAggregator> var1);

        public Builder aggregators(InventoryAggregator ... var1);

        public Builder aggregators(Consumer<Builder> ... var1);
    }
}

