/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetDocumentResponse> {
    private final String name;
    private final String documentVersion;
    private final String content;
    private final String documentType;

    private GetDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.content = builder.content;
        this.documentType = builder.documentType;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String content() {
        return this.content;
    }

    public DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public String documentTypeAsString() {
        return this.documentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentResponse)) {
            return false;
        }
        GetDocumentResponse other = (GetDocumentResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetDocumentResponse").add("Name", (Object)this.name()).add("DocumentVersion", (Object)this.documentVersion()).add("Content", (Object)this.content()).add("DocumentType", (Object)this.documentTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String name;
        private String documentVersion;
        private String content;
        private String documentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentResponse model) {
            super(model);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.content(model.content);
            this.documentType(model.documentType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public GetDocumentResponse build() {
            return new GetDocumentResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, GetDocumentResponse> {
        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder content(String var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);
    }
}

