/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePatchGroupStateResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribePatchGroupStateResponse> {
    private final Integer instances;
    private final Integer instancesWithInstalledPatches;
    private final Integer instancesWithInstalledOtherPatches;
    private final Integer instancesWithMissingPatches;
    private final Integer instancesWithFailedPatches;
    private final Integer instancesWithNotApplicablePatches;

    private DescribePatchGroupStateResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.instancesWithInstalledPatches = builder.instancesWithInstalledPatches;
        this.instancesWithInstalledOtherPatches = builder.instancesWithInstalledOtherPatches;
        this.instancesWithMissingPatches = builder.instancesWithMissingPatches;
        this.instancesWithFailedPatches = builder.instancesWithFailedPatches;
        this.instancesWithNotApplicablePatches = builder.instancesWithNotApplicablePatches;
    }

    public Integer instances() {
        return this.instances;
    }

    public Integer instancesWithInstalledPatches() {
        return this.instancesWithInstalledPatches;
    }

    public Integer instancesWithInstalledOtherPatches() {
        return this.instancesWithInstalledOtherPatches;
    }

    public Integer instancesWithMissingPatches() {
        return this.instancesWithMissingPatches;
    }

    public Integer instancesWithFailedPatches() {
        return this.instancesWithFailedPatches;
    }

    public Integer instancesWithNotApplicablePatches() {
        return this.instancesWithNotApplicablePatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledOtherPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithMissingPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithFailedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithNotApplicablePatches());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupStateResponse)) {
            return false;
        }
        DescribePatchGroupStateResponse other = (DescribePatchGroupStateResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances()) && Objects.equals(this.instancesWithInstalledPatches(), other.instancesWithInstalledPatches()) && Objects.equals(this.instancesWithInstalledOtherPatches(), other.instancesWithInstalledOtherPatches()) && Objects.equals(this.instancesWithMissingPatches(), other.instancesWithMissingPatches()) && Objects.equals(this.instancesWithFailedPatches(), other.instancesWithFailedPatches()) && Objects.equals(this.instancesWithNotApplicablePatches(), other.instancesWithNotApplicablePatches());
    }

    public String toString() {
        return ToString.builder((String)"DescribePatchGroupStateResponse").add("Instances", (Object)this.instances()).add("InstancesWithInstalledPatches", (Object)this.instancesWithInstalledPatches()).add("InstancesWithInstalledOtherPatches", (Object)this.instancesWithInstalledOtherPatches()).add("InstancesWithMissingPatches", (Object)this.instancesWithMissingPatches()).add("InstancesWithFailedPatches", (Object)this.instancesWithFailedPatches()).add("InstancesWithNotApplicablePatches", (Object)this.instancesWithNotApplicablePatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "InstancesWithInstalledPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledPatches()));
            }
            case "InstancesWithInstalledOtherPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledOtherPatches()));
            }
            case "InstancesWithMissingPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithMissingPatches()));
            }
            case "InstancesWithFailedPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithFailedPatches()));
            }
            case "InstancesWithNotApplicablePatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithNotApplicablePatches()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private Integer instances;
        private Integer instancesWithInstalledPatches;
        private Integer instancesWithInstalledOtherPatches;
        private Integer instancesWithMissingPatches;
        private Integer instancesWithFailedPatches;
        private Integer instancesWithNotApplicablePatches;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupStateResponse model) {
            super(model);
            this.instances(model.instances);
            this.instancesWithInstalledPatches(model.instancesWithInstalledPatches);
            this.instancesWithInstalledOtherPatches(model.instancesWithInstalledOtherPatches);
            this.instancesWithMissingPatches(model.instancesWithMissingPatches);
            this.instancesWithFailedPatches(model.instancesWithFailedPatches);
            this.instancesWithNotApplicablePatches(model.instancesWithNotApplicablePatches);
        }

        public final Integer getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(Integer instances) {
            this.instances = instances;
        }

        public final Integer getInstancesWithInstalledPatches() {
            return this.instancesWithInstalledPatches;
        }

        @Override
        public final Builder instancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
            return this;
        }

        public final void setInstancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
        }

        public final Integer getInstancesWithInstalledOtherPatches() {
            return this.instancesWithInstalledOtherPatches;
        }

        @Override
        public final Builder instancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
            return this;
        }

        public final void setInstancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
        }

        public final Integer getInstancesWithMissingPatches() {
            return this.instancesWithMissingPatches;
        }

        @Override
        public final Builder instancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
            return this;
        }

        public final void setInstancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
        }

        public final Integer getInstancesWithFailedPatches() {
            return this.instancesWithFailedPatches;
        }

        @Override
        public final Builder instancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
            return this;
        }

        public final void setInstancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
        }

        public final Integer getInstancesWithNotApplicablePatches() {
            return this.instancesWithNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
            return this;
        }

        public final void setInstancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
        }

        @Override
        public DescribePatchGroupStateResponse build() {
            return new DescribePatchGroupStateResponse(this);
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    CopyableBuilder<Builder, DescribePatchGroupStateResponse> {
        public Builder instances(Integer var1);

        public Builder instancesWithInstalledPatches(Integer var1);

        public Builder instancesWithInstalledOtherPatches(Integer var1);

        public Builder instancesWithMissingPatches(Integer var1);

        public Builder instancesWithFailedPatches(Integer var1);

        public Builder instancesWithNotApplicablePatches(Integer var1);
    }
}

