/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterTargetFromMaintenanceWindowRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowRequest> {
    private final String windowId;
    private final String windowTargetId;
    private final Boolean safe;

    private DeregisterTargetFromMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.safe = builder.safe;
    }

    public String windowId() {
        return this.windowId;
    }

    public String windowTargetId() {
        return this.windowTargetId;
    }

    public Boolean safe() {
        return this.safe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.safe());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetFromMaintenanceWindowRequest)) {
            return false;
        }
        DeregisterTargetFromMaintenanceWindowRequest other = (DeregisterTargetFromMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTargetId(), other.windowTargetId()) && Objects.equals(this.safe(), other.safe());
    }

    public String toString() {
        return ToString.builder((String)"DeregisterTargetFromMaintenanceWindowRequest").add("WindowId", (Object)this.windowId()).add("WindowTargetId", (Object)this.windowTargetId()).add("Safe", (Object)this.safe()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "WindowTargetId": {
                return Optional.ofNullable(clazz.cast(this.windowTargetId()));
            }
            case "Safe": {
                return Optional.ofNullable(clazz.cast(this.safe()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTargetId;
        private Boolean safe;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTargetFromMaintenanceWindowRequest model) {
            super(model);
            this.windowId(model.windowId);
            this.windowTargetId(model.windowTargetId);
            this.safe(model.safe);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final Boolean getSafe() {
            return this.safe;
        }

        @Override
        public final Builder safe(Boolean safe) {
            this.safe = safe;
            return this;
        }

        public final void setSafe(Boolean safe) {
            this.safe = safe;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterTargetFromMaintenanceWindowRequest build() {
            return new DeregisterTargetFromMaintenanceWindowRequest(this);
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    CopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder windowTargetId(String var1);

        public Builder safe(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

