/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMaintenanceWindowRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateMaintenanceWindowRequest> {
    private final String name;
    private final String description;
    private final String schedule;
    private final Integer duration;
    private final Integer cutoff;
    private final Boolean allowUnassociatedTargets;
    private final String clientToken;

    private CreateMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.clientToken = builder.clientToken;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String schedule() {
        return this.schedule;
    }

    public Integer duration() {
        return this.duration;
    }

    public Integer cutoff() {
        return this.cutoff;
    }

    public Boolean allowUnassociatedTargets() {
        return this.allowUnassociatedTargets;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMaintenanceWindowRequest)) {
            return false;
        }
        CreateMaintenanceWindowRequest other = (CreateMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff()) && Objects.equals(this.allowUnassociatedTargets(), other.allowUnassociatedTargets()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateMaintenanceWindowRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Schedule", (Object)this.schedule()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).add("AllowUnassociatedTargets", (Object)this.allowUnassociatedTargets()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.ofNullable(clazz.cast(this.cutoff()));
            }
            case "AllowUnassociatedTargets": {
                return Optional.ofNullable(clazz.cast(this.allowUnassociatedTargets()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String schedule;
        private Integer duration;
        private Integer cutoff;
        private Boolean allowUnassociatedTargets;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMaintenanceWindowRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.schedule(model.schedule);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
            this.allowUnassociatedTargets(model.allowUnassociatedTargets);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return this.allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMaintenanceWindowRequest build() {
            return new CreateMaintenanceWindowRequest(this);
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    CopyableBuilder<Builder, CreateMaintenanceWindowRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder schedule(String var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);

        public Builder allowUnassociatedTargets(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

