/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;
import software.amazon.awssdk.services.ssm.transform.NonCompliantSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NonCompliantSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, NonCompliantSummary> {
    private final Integer nonCompliantCount;
    private final SeveritySummary severitySummary;

    private NonCompliantSummary(BuilderImpl builder) {
        this.nonCompliantCount = builder.nonCompliantCount;
        this.severitySummary = builder.severitySummary;
    }

    public Integer nonCompliantCount() {
        return this.nonCompliantCount;
    }

    public SeveritySummary severitySummary() {
        return this.severitySummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.severitySummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonCompliantSummary)) {
            return false;
        }
        NonCompliantSummary other = (NonCompliantSummary)obj;
        return Objects.equals(this.nonCompliantCount(), other.nonCompliantCount()) && Objects.equals(this.severitySummary(), other.severitySummary());
    }

    public String toString() {
        return ToString.builder((String)"NonCompliantSummary").add("NonCompliantCount", (Object)this.nonCompliantCount()).add("SeveritySummary", (Object)this.severitySummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NonCompliantCount": {
                return Optional.of(clazz.cast(this.nonCompliantCount()));
            }
            case "SeveritySummary": {
                return Optional.of(clazz.cast(this.severitySummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NonCompliantSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer nonCompliantCount;
        private SeveritySummary severitySummary;

        private BuilderImpl() {
        }

        private BuilderImpl(NonCompliantSummary model) {
            this.nonCompliantCount(model.nonCompliantCount);
            this.severitySummary(model.severitySummary);
        }

        public final Integer getNonCompliantCount() {
            return this.nonCompliantCount;
        }

        @Override
        public final Builder nonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
            return this;
        }

        public final void setNonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
        }

        public final SeveritySummary.Builder getSeveritySummary() {
            return this.severitySummary != null ? this.severitySummary.toBuilder() : null;
        }

        @Override
        public final Builder severitySummary(SeveritySummary severitySummary) {
            this.severitySummary = severitySummary;
            return this;
        }

        public final void setSeveritySummary(SeveritySummary.BuilderImpl severitySummary) {
            this.severitySummary = severitySummary != null ? severitySummary.build() : null;
        }

        public NonCompliantSummary build() {
            return new NonCompliantSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NonCompliantSummary> {
        public Builder nonCompliantCount(Integer var1);

        public Builder severitySummary(SeveritySummary var1);

        default public Builder severitySummary(Consumer<SeveritySummary.Builder> severitySummary) {
            return this.severitySummary((SeveritySummary)((SeveritySummary.Builder)SeveritySummary.builder().apply(severitySummary)).build());
        }
    }
}

