/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.ParametersFilter;

public class ParametersFilterUnmarshaller
implements Unmarshaller<ParametersFilter, JsonUnmarshallerContext> {
    private static ParametersFilterUnmarshaller INSTANCE;

    public ParametersFilter unmarshall(JsonUnmarshallerContext context) throws Exception {
        ParametersFilter.Builder parametersFilterBuilder = ParametersFilter.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Key", targetDepth)) {
                    context.nextToken();
                    parametersFilterBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Values", targetDepth)) {
                    context.nextToken();
                    parametersFilterBuilder.values(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ParametersFilter)parametersFilterBuilder.build();
    }

    public static ParametersFilterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ParametersFilterUnmarshaller();
        }
        return INSTANCE;
    }
}

