/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.InventoryItem;
import software.amazon.awssdk.services.ssm.model.InventoryItemListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutInventoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutInventoryRequest> {
    private final String instanceId;
    private final List<InventoryItem> items;

    private PutInventoryRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.items = builder.items;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<InventoryItem> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInventoryRequest)) {
            return false;
        }
        PutInventoryRequest other = (PutInventoryRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private List<InventoryItem> items = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInventoryRequest model) {
            this.setInstanceId(model.instanceId);
            this.setItems(model.items);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<InventoryItem> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<InventoryItem> items) {
            this.items = InventoryItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(InventoryItem ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (InventoryItem e : items) {
                this.items.add(e);
            }
            return this;
        }

        public final void setItems(Collection<InventoryItem> items) {
            this.items = InventoryItemListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(InventoryItem ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (InventoryItem e : items) {
                this.items.add(e);
            }
        }

        public PutInventoryRequest build() {
            return new PutInventoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutInventoryRequest> {
        public Builder instanceId(String var1);

        public Builder items(Collection<InventoryItem> var1);

        public Builder items(InventoryItem ... var1);
    }
}

