/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.PatchDeploymentStatus;
import software.amazon.awssdk.services.ssm.transform.PatchStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchStatus> {
    private final String deploymentStatus;
    private final Date approvalDate;

    private PatchStatus(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
        this.approvalDate = builder.approvalDate;
    }

    public String deploymentStatus() {
        return this.deploymentStatus;
    }

    public Date approvalDate() {
        return this.approvalDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentStatus() == null ? 0 : this.deploymentStatus().hashCode());
        hashCode = 31 * hashCode + (this.approvalDate() == null ? 0 : this.approvalDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchStatus)) {
            return false;
        }
        PatchStatus other = (PatchStatus)obj;
        if (other.deploymentStatus() == null ^ this.deploymentStatus() == null) {
            return false;
        }
        if (other.deploymentStatus() != null && !other.deploymentStatus().equals(this.deploymentStatus())) {
            return false;
        }
        if (other.approvalDate() == null ^ this.approvalDate() == null) {
            return false;
        }
        return other.approvalDate() == null || other.approvalDate().equals(this.approvalDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentStatus() != null) {
            sb.append("DeploymentStatus: ").append(this.deploymentStatus()).append(",");
        }
        if (this.approvalDate() != null) {
            sb.append("ApprovalDate: ").append(this.approvalDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String deploymentStatus;
        private Date approvalDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchStatus model) {
            this.setDeploymentStatus(model.deploymentStatus);
            this.setApprovalDate(model.approvalDate);
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(PatchDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final void setDeploymentStatus(PatchDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
        }

        public final Date getApprovalDate() {
            return this.approvalDate;
        }

        @Override
        public final Builder approvalDate(Date approvalDate) {
            this.approvalDate = StandardMemberCopier.copy((Date)approvalDate);
            return this;
        }

        public final void setApprovalDate(Date approvalDate) {
            this.approvalDate = StandardMemberCopier.copy((Date)approvalDate);
        }

        public PatchStatus build() {
            return new PatchStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchStatus> {
        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(PatchDeploymentStatus var1);

        public Builder approvalDate(Date var1);
    }
}

